%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'VDS_FOUT_NO_O_down.csv',...      % Vctrl = 18 V, Vref = 1 V
         'VDS_FOUT_NO_N_down.csv',...      % Vctrl = 19 V, Vref = 1 V
         'VDS_FOUT_NO_flat.csv',...        % Vctrl = 20 V, Vref = 1 V
         'VDS_FOUT_NO2_O_down.csv',...     % Vctrl = 27 V, Vref = 1.7 V
         'VDS_FOUT_NO2_N_down.csv',...     % Vctrl = 28 V, Vref = 1.7 V
         'VDS_FOUT_NO2_flat.csv',...       % Vctrl = 29 V, Vref = 1.7 V
         };    

[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file


%% Extracting data
importfile(file);
[raws,columns] = size(data);

t = 1;

for tt = 1:2:(columns/2)-1
    time(:,t) = data(:,tt);
    t = t + 1;
end

j = 1;

for i = 2:2:(columns/2)
    VDS(:,j) = data(:,i);
    FOUT(:,j) = data(:,i+16);
    
    j = j + 1;
end

% Atmospheric gases
Vctrl_atm = [3:1:10];           % Vctrl of atmospheric gas

k = 1;

% Time in ns
time_ns = time*1e9;

% Table of results
VDS_FOUT_meas = zeros(length(Vctrl_atm),4);
r = 1;

for k = 1:length(Vctrl_atm)
    %% Calculation of average values of currents
    VDS_meas = VDS(:,k);
    j_v0 = find(VDS(:,k)==0);
    
    VDS_meas(j_v0) = [];
    VDS_meas(isnan(VDS_meas)) = [];
    
    diff_VDS_meas = [0; diff(VDS_meas)];
    
    [max_i_diff,j_VDS_edges] = maxk(abs(diff_VDS_meas),2);

    j_VDS_edges = sort(j_VDS_edges);
    
    VDS_atm_1 = VDS_meas(1:j_VDS_edges(1)-1);
    VDS_atm_3 = VDS_meas(j_VDS_edges(2):end);

    VDS_atm = [VDS_atm_1;...
               VDS_atm_3];

    VDS_target = [VDS_meas(j_VDS_edges(1):...
                             (j_VDS_edges(2)-1))];
    

    % Average and standard deviation of voltages
    VDS_atm_1_avg = mean(VDS_atm_1)         % [V]
    VDS_atm_1_std = std(VDS_atm_1);          % [V]
    
    VDS_target_avg = mean(VDS_target)   % [V]
    VDS_target_std = std(VDS_target);    % [V]

    VDS_atm_3_avg = mean(VDS_atm_3)         % [V]
    VDS_atm_3_std = std(VDS_atm_3);          % [V]

    VDS_atm_avg = mean(VDS_atm);         % [V]
    VDS_atm_std = std(VDS_atm);          % [V]


    %% Calculation of average values of frequencies
    FOUT_meas = FOUT(:,k);
    j_f0 = find(FOUT(:,k)==0);
    
    FOUT_meas(j_f0) = [];
    FOUT_meas(isnan(FOUT_meas)) = [];
    
    diff_FOUT_meas = [0; diff(FOUT_meas)];
    
    [max_f_diff,j_FOUT_edges] = maxk(abs(diff_FOUT_meas),2);

    j_FOUT_edges = sort(j_FOUT_edges);
    
    FOUT_atm_1 = FOUT_meas(1:j_FOUT_edges(1)-1);
    FOUT_atm_3 = FOUT_meas(j_FOUT_edges(2):end);

    FOUT_atm = [FOUT_atm_1;...
                FOUT_atm_3];

    FOUT_target = [FOUT_meas(j_FOUT_edges(1):...
                             (j_FOUT_edges(2)-1))];
    
    % Average and standard deviation of frequencies
    FOUT_atm_1_avg = mean(FOUT_atm_1)*1e-6      % [MHz]
    FOUT_atm_1_std = std(FOUT_atm_1)*1e-6;       % [MHz]
    
    FOUT_target_avg = mean(FOUT_target)*1e-6      % [MHz]      
    FOUT_target_std = std(FOUT_target)*1e-6;       % [MHz]

    FOUT_atm_3_avg = mean(FOUT_atm_3)*1e-6      % [MHz]
    FOUT_atm_3_std = std(FOUT_atm_3)*1e-6;       % [MHz]

    FOUT_atm_avg = mean(FOUT_atm)*1e-6      % [MHz]
    FOUT_atm_std = std(FOUT_atm)*1e-6;       % [MHz]
    
    
    % Table of results
    VDS_FOUT_meas(r,:) = [VDS_target_avg, VDS_atm_avg,...
                          FOUT_target_avg, FOUT_atm_avg];

    r = r + 1;
    
    %% Writing data on Excel
    write_NO = 'meas_VDS_FOUT_NO.xlsx';
    write_NO2 = 'meas_VDS_FOUT_NO2.xlsx';
    
    VDS_w = VDS_FOUT_meas([1:8],[1:2]);
    FOUT_w = VDS_FOUT_meas([1:8],[3:4]);
    
    switch file
        case 'VDS_FOUT_NO_O_down.csv'
            writematrix(VDS_w,write_NO,'Sheet',1,'Range','C3:D10');
            writematrix(FOUT_w,write_NO,'Sheet',1,'Range','F3:G10');

        case 'VDS_FOUT_NO_N_down.csv'
            writematrix(VDS_w,write_NO,'Sheet',2,'Range','C3:D10');
            writematrix(FOUT_w,write_NO,'Sheet',2,'Range','F3:G10');

        case 'VDS_FOUT_NO_flat.csv'
            writematrix(VDS_w,write_NO,'Sheet',3,'Range','C3:D10');
            writematrix(FOUT_w,write_NO,'Sheet',3,'Range','F3:G10');
    
        case 'VDS_FOUT_NO2_O_down.csv'
            writematrix(VDS_w,write_NO2,'Sheet',1,'Range','C3:D10');
            writematrix(FOUT_w,write_NO2,'Sheet',1,'Range','F3:G10');
        
        case 'VDS_FOUT_NO2_N_down.csv'
            writematrix(VDS_w,write_NO2,'Sheet',2,'Range','C3:D10');
            writematrix(FOUT_w,write_NO2,'Sheet',2,'Range','F3:G10');
    
        case 'VDS_FOUT_NO2_flat.csv'
            writematrix(VDS_w,write_NO2,'Sheet',3,'Range','C3:D10');
            writematrix(FOUT_w,write_NO2,'Sheet',3,'Range','F3:G10');
    end
    
end





